<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Serverless\V1\Service\Environment;

use Twilio\Options;
use Twilio\Values;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 */
abstract class VariableOptions {
    /**
     * @param string $key A string by which this Variable can be referenced.
     * @param string $value A string that contains the actual value of this
     *                      Variable.
     * @return UpdateVariableOptions Options builder
     */
    public static function update($key = Values::NONE, $value = Values::NONE) {
        return new UpdateVariableOptions($key, $value);
    }
}

class UpdateVariableOptions extends Options {
    /**
     * @param string $key A string by which this Variable can be referenced.
     * @param string $value A string that contains the actual value of this
     *                      Variable.
     */
    public function __construct($key = Values::NONE, $value = Values::NONE) {
        $this->options['key'] = $key;
        $this->options['value'] = $value;
    }

    /**
     * A string by which this Variable can be referenced, fewer than 128 characters. Optional.
     *
     * @param string $key A string by which this Variable can be referenced.
     * @return $this Fluent Builder
     */
    public function setKey($key) {
        $this->options['key'] = $key;
        return $this;
    }

    /**
     * A string that contains the actual value of this Variable, less than 450 bytes. Optional.
     *
     * @param string $value A string that contains the actual value of this
     *                      Variable.
     * @return $this Fluent Builder
     */
    public function setValue($value) {
        $this->options['value'] = $value;
        return $this;
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString() {
        $options = array();
        foreach ($this->options as $key => $value) {
            if ($value != Values::NONE) {
                $options[] = "$key=$value";
            }
        }
        return '[Twilio.Serverless.V1.UpdateVariableOptions ' . implode(' ', $options) . ']';
    }
}