<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Staff_model extends CI_model {

    function __construct() {
        parent::__construct();
        $this->load->database();
    }

    function insertStaff($data) {
        $this->db->insert('staff', $data);
    }

    function getStaff() {
        $query = $this->db->get('staff');
        return $query->result();
    }

    function getStaffById($id) {
        $this->db->where('id', $id);
        $query = $this->db->get('staff');
        return $query->row();
    }

    function getWorkingStaff() {
        $this->db->where('staff.status', lang('status_working'));
        $this->db->order_by('staff.name','asc');
        $this->db->select("staff.*,department.name AS departmentName ");
        $this->db->from("staff");
        $this->db->join("department",'department.id=staff.department');
        $query=$this->db->get();
        return $query->result();
    }


    function updateStaff($id, $data) {
        $this->db->where('id', $id);
        $this->db->update('staff', $data);
    }

    function delete($id) {
        $this->db->where('id', $id);
        $this->db->delete('staff');
    }

    function updateIonUser($username, $email, $password, $ion_user_id) {
        $uptade_ion_user = array(
            'username' => $username,
            'email' => $email,
            'password' => $password
        );
        $this->db->where('id', $ion_user_id);
        $this->db->update('users', $uptade_ion_user);
    }

    function getStaffByIonUserId($id) {
        $this->db->where('ion_user_id', $id);
        $query = $this->db->get('staff');
        return $query->row();
    }

    function insertLeave($data)
    {
        $this->db->insert("staff_leave",$data);
    }

    function getLeave()
    {
        $this->db->order_by('staff_leave.id','desc');
        $this->db->select("staff_leave.*,staff.name AS staffName,staff.phone,department.name AS departmentName ");
        $this->db->from("staff_leave");
        $this->db->join("staff",'staff.id=staff_leave.staff');
        $this->db->join("department",'department.id=staff.department');
        $query=$this->db->get();
        return $query->result();
    }

    function getLeaveById($id)
    {
        $this->db->where('staff_leave.id',$id);
        $this->db->select("staff_leave.*,staff.name AS staffName,staff.phone,department.name AS departmentName ");
        $this->db->from("staff_leave");
        $this->db->join("staff",'staff.id=staff_leave.staff');
        $this->db->join("department",'department.id=staff.department');
        $query=$this->db->get();
        return $query->row();
    }

    function updateLeave($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('staff_leave',$data);
    }

    function deleteLeave($id) {
        $this->db->where('id', $id);
        $this->db->delete('staff_leave');
    }

    function insertSalary($data) {
        $this->db->insert('staff_salary', $data);
    }

    function getSalary()
    {
        $this->db->order_by('staff_salary.id','desc');
        $this->db->select("staff_salary.*,staff.name AS staffName,staff.phone,department.name AS departmentName ");
        $this->db->from("staff_salary");
        $this->db->join("staff",'staff.id=staff_salary.staff');
        $this->db->join("department",'department.id=staff.department');
        $query=$this->db->get();
        return $query->result();
    }
    
    function getSalaryById($id)
    {
        $this->db->where('staff_salary.id',$id);
        $this->db->select("staff_salary.*,staff.name AS staffName,staff.phone,department.name AS departmentName ");
        $this->db->from("staff_salary");
        $this->db->join("staff",'staff.id=staff_salary.staff');
        $this->db->join("department",'department.id=staff.department');
        $query=$this->db->get();
        return $query->row();
    }

    function updateSalary($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('staff_salary',$data);
    }

    function deleteSalary($id) {
        $this->db->where('id', $id);
        $this->db->delete('staff_salary');
    }

    function getLeaveByStaffByDates($staff,$d_first,$d_last)
    {
        $this->db->where('staff',$staff);
        $this->db->where('status', lang('approved'));   
        $fetched_records = $this->db->get('staff_leave');
        $leaves = $fetched_records->result_array();

        // Initialize Array with fetched data
        $data = array();

    foreach ($leaves as $leave) {
        if (($leave['leave_from'] >=$d_first) && ($leave['leave_from'] <=$d_last))
        {
        $totalLeave=0;
        $leave_from =$leave['leave_from'];
        $leave_to =$leave['leave_to'];
        $leave_from_date=date("Y-m-d",$leave_from);
        $leave_to_date=date("Y-m-d",$leave_to);
        $remaining_days_from=date("t",$leave_from)-date("j",$leave_from)+1;
        $start    = (new DateTime($leave_from_date))->modify('first day of this month');
        $end      = (new DateTime($leave_to_date))->modify('first day of next month');
        $interval = DateInterval::createFromDateString('1 month');
        $period   = new DatePeriod($start, $interval, $end);
        $months=iterator_count($period);
        if ($months == 1) //same month
        $totalLeave=$leave['total_leave'];
        else // 2 months
        $totalLeave=$remaining_days_from;

        $data[]=$totalLeave;
        } 

        if (($leave['leave_to'] >=$d_first) && ($leave['leave_to'] <=$d_last))
        {
            $totalLeave=0;
            $leave_from =$leave['leave_from'];
            $leave_to =$leave['leave_to'];
            $leave_from_date=date("Y-m-d",$leave_from);
            $leave_to_date=date("Y-m-d",$leave_to);
   
            $start    = (new DateTime($leave_from_date))->modify('first day of this month');
            $end      = (new DateTime($leave_to_date))->modify('first day of next month');
            $interval = DateInterval::createFromDateString('1 month');
            $period   = new DatePeriod($start, $interval, $end);
            $months=iterator_count($period);
            if ($months > 1) // 2 months
            $totalLeave=date("j",$leave_to); 

            $data[]=$totalLeave;
        } 
    }
    return array_sum($data);
    }

    function getSalaryByDate($date_from, $date_to) {
        $this->db->select("sum(total_salary) AS tot_salary,count(basic_salary) AS freq_basic_salary");
        $this->db->where('payment_date >=', $date_from);
        $this->db->where('payment_date <=', $date_to); 
        $this->db->from("staff_salary");
        $query=$this->db->get()->result();
        return $query;
    }

    function thisDayStaffSalary() {
        $hour = 0;
        $today = strtotime($hour . ':00:00'); // 0:00:00 means today
        $today_last = strtotime($hour . ':00:00') + 86399; //11:59:59 means today last time
        $this->db->select('count(id) as salary_number, sum(total_salary) as total');
        $this->db->where('payment_date >=', $today);
        $this->db->where('payment_date <=', $today_last);
        $this->db->from('staff_salary');
        $query = $this->db->get()->result();
        return $query;
    }

    function thisMonthStaffSalary() {
        $date_from = strtotime('first day of '. date ('F Y')); 
        $date_to = strtotime('last day of '. date ('F Y')) + 86399; //11:59:59 PM
        $this->db->select_sum('total_salary');
        $this->db->where('payment_date >=', $date_from);
        $this->db->where('payment_date <=', $date_to);
        $this->db->from('staff_salary');
        $query = $this->db->get()->result();
        return $query[0]->total_salary;
    }

    function getStaffSalaryPerMonthThisYear() {
        $query = $this->db->select('payment_date,total_salary')->get('staff_salary')->result();
        $total = array();
        foreach ($query as $q) {
            if (date('Y', time()) == date('Y', $q->payment_date)) {
                if (date('m', $q->payment_date) == '01') {
                    $total['january'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '02') {
                    $total['february'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '03') {
                    $total['march'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '04') {
                    $total['april'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '05') {
                    $total['may'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '06') {
                    $total['june'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '07') {
                    $total['july'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '08') {
                    $total['august'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '09') {
                    $total['september'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '10') {
                    $total['october'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '11') {
                    $total['november'][] = $q->total_salary;
                }
                if (date('m', $q->payment_date) == '12') {
                    $total['december'][] = $q->total_salary;
                }
            }
        }


        if (!empty($total['january'])) {
            $total['january'] = array_sum($total['january']);
        } else {
            $total['january'] = 0;
        }
        if (!empty($total['february'])) {
            $total['february'] = array_sum($total['february']);
        } else {
            $total['february'] = 0;
        }
        if (!empty($total['march'])) {
            $total['march'] = array_sum($total['march']);
        } else {
            $total['march'] = 0;
        }
        if (!empty($total['april'])) {
            $total['april'] = array_sum($total['april']);
        } else {
            $total['april'] = 0;
        }
        if (!empty($total['may'])) {
            $total['may'] = array_sum($total['may']);
        } else {
            $total['may'] = 0;
        }
        if (!empty($total['june'])) {
            $total['june'] = array_sum($total['june']);
        } else {
            $total['june'] = 0;
        }
        if (!empty($total['july'])) {
            $total['july'] = array_sum($total['july']);
        } else {
            $total['july'] = 0;
        }
        if (!empty($total['august'])) {
            $total['august'] = array_sum($total['august']);
        } else {
            $total['august'] = 0;
        }
        if (!empty($total['september'])) {
            $total['september'] = array_sum($total['september']);
        } else {
            $total['september'] = 0;
        }
        if (!empty($total['october'])) {
            $total['october'] = array_sum($total['october']);
        } else {
            $total['october'] = 0;
        }
        if (!empty($total['november'])) {
            $total['november'] = array_sum($total['november']);
        } else {
            $total['november'] = 0;
        }
        if (!empty($total['december'])) {
            $total['december'] = array_sum($total['december']);
        } else {
            $total['december'] = 0;
        }

        return $total;
    }

    function getStaffSalaryByDateList($date_from, $date_to) {
        $this->db->select('*');
        $this->db->from('staff_salary');
        $this->db->where('payment_date >=', $date_from);
        $this->db->where('payment_date <=', $date_to); 
        $query = $this->db->get();
        return $query->result();
    }
}
