<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Lab extends MX_Controller {

    function __construct() {
        parent::__construct();
        $this->load->model('lab_model');
		$this->load->model('laboratorist/laboratorist_model'); //added by shariat
        $this->load->model('doctor/doctor_model');
        $this->load->model('patient/patient_model');
		$this->load->model('finance/finance_model'); //added by shariat
        $this->load->model('accountant/accountant_model');
        $this->load->model('receptionist/receptionist_model');
        $this->load->module('sms');
        if (!$this->ion_auth->in_group(array('admin', 'Accountant', 'Receptionist', 'Laboratorist', 'Doctor'))) {
            redirect('home/permission');
        }
    }

    public function index() {

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->ion_auth->in_group(array('Patient'))) {
            redirect('home/permission');
        }

        if ($this->ion_auth->in_group(array('Receptionist'))) {
            redirect('lab/lab1');
        }

        $id = $this->input->get('id');

        $data['settings'] = $this->settings_model->getSettings();
        $data['labs'] = $this->lab_model->getLab();

        if (!empty($id)) {
            $data['lab_single'] = $this->lab_model->getLabById($id);
            $data['patients'] = $this->patient_model->getPatientById($data['lab_single']->patient);
            $data['doctors'] = $this->doctor_model->getDoctorById($data['lab_single']->doctor);
        }

        $data['templates'] = $this->lab_model->getTemplate();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->lab_model->getLabCategory();


        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function lab() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }

        if ($this->ion_auth->in_group(array('Patient'))) {
            redirect('home/permission');
        }

        $id = $this->input->get('id');



        $data['templates'] = $this->lab_model->getTemplate();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->lab_model->getLabCategory();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();

        $data['settings'] = $this->settings_model->getSettings();
        $data['labs'] = $this->lab_model->getLab();

        if (!empty($id)) {
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_lab_view', $data);
            $this->load->view('home/footer'); // just the header file
        } else {
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('lab', $data);
            $this->load->view('home/footer'); // just the header file
        }
    }

    public function lab1() {
   
        $id = $this->input->get('id');

        if (!empty($id)) {
            $data['lab_single'] = $this->lab_model->getLabById($id);
        }

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_1', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function lab1Laboratorist() {
        $id = $this->input->get('id');

        if (!empty($id)) {
            $data['lab_single'] = $this->lab_model->getLabById($id);
        }


        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_1_laboratorist', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function labToday() {

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }

        $id = $this->input->get('id');

        $data['settings'] = $this->settings_model->getSettings();
        $data['labs'] = $this->lab_model->getLab();

        if (!empty($id)) {
            $data['lab_single'] = $this->lab_model->getLabById($id);
        }

        $data['templates'] = $this->lab_model->getTemplate();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->lab_model->getLabCategory();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_1', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addLabView() {
        $data = array();
        $id = $this->input->get('id');

        if (!empty($id)) {
            $data['lab'] = $this->lab_model->getLabById($id);
            $data['patients'] = $this->patient_model->getPatientById($data['lab_single']->patient);
            $data['doctors'] = $this->doctor_model->getDoctorById($data['lab_single']->doctor);
        }

	    //$data['payments_categories'] = $this->finance_model->getPaymentCategoryForLab(); //added by shariat
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->lab_model->getLabCategory();
        $data['labFooters'] = $this->lab_model->getLabFooter();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_lab_view', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addLab() {
        $specimen=$this->input->post('specimen');
        $id = $this->input->post('id');
        $report = $this->input->post('report');

        $patient = $this->input->post('patient');
        $template_selected = array();

        $templates_selected = $this->input->post('template');
        $category_name="";
        foreach ($templates_selected as $template){     
            $templateDetails = $this->lab_model->getTemplateByTestId($template);
            $category_name = $templateDetails->name.'; '.$category_name;
        }  

        $category = implode(",",$templates_selected);

        

        $sms_to_doctor = $this->input->post('sms_to_doctor');
        $sample_coll_date = $this->input->post('sample_coll_date');
        $invoice = $this->input->post('invoice');
        $lab_footer = $this->input->post('lab_footer');
       
        if (!empty($sample_coll_date)) {
            $sample_coll_date = strtotime($sample_coll_date);
        }
        $date = $this->input->post('date');
        if (!empty($date)) {
            $date = strtotime($date);
        } else {
            $date = time();
        }
        $date_string = date('d-m-y', $date);
        $user = $this->ion_auth->get_user_id();

        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');


        $this->form_validation->set_rules('patient', 'Patient', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        //$this->form_validation->set_rules('template', 'Template', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('sample_coll_date', 'Sample Collection Date', 'trim|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('report', 'Report', 'trim|min_length[1]|xss_clean');
        $this->form_validation->set_rules('invoice', 'Invoice', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('lab_footer', 'Lab Footer', 'trim|required|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
			$this->session->set_flashdata('feedback', lang('validation_error'));
            redirect('lab/addLabView');
        } else {

                $doctor=$this->finance_model->getPaymentById($invoice)->x_ray; //changed to consulted by from reff. doctor
                $patient_details = $this->patient_model->getPatientById($patient);
                $patient_name = $patient_details->name;
                $patient_phone = $patient_details->phone;       
        
            $data = array();

            if (empty($id)) {
                $data = array(
                    'report' => $report,
                    'patient' => $patient,
                    'category' => $category,
                    'category_name' => $category_name,
                    'sample_coll_date' => $sample_coll_date,
                    'date' => $date,
                    'doctor' => $doctor,
                    'user' => $user,
                    'patient_name' => $patient_name,
                    'patient_phone' => $patient_phone,
                    'invoice' => $invoice,
                    'lab_footer' => $lab_footer,
                    'status' => $specimen
                );

                $this->lab_model->insertLab($data);
                $inserted_id = $this->db->insert_id();

                $settings = $this->settings_model->getSettings();

                //sms to patient
                $message =rawurlencode('Dear Sir/Madam, Your '.$category_name.' Report is ready to deliver. Please collect it from Delivery Counter. For any query, please call Hotline number '. $settings->phone.'. May Allah swt give recovery. Thanking You, ' .$settings->title.', '.$settings->address); //added by shariat
                $this->sms->sendSms('$countrycode'.$patient_phone, $message); //added by shariat
                
                 //sms to doctor
                if ($sms_to_doctor == lang('yes'))
                {
                $message_doctor =rawurlencode('Dear Sir/Madam, '. $category_name.' Report of ' . $patient_name.' ('.lang('patient').' '. lang('id').':'.$patient.') is done. Thanking You, ' .$settings->title.', '.$settings->address); //added by shariat
                $this->sms->sendSms('$countrycode'.$doctor_details->phone, $message_doctor); //added by shariat
                }

                $this->session->set_flashdata('feedback',  'Added');
				redirect("lab/invoice?id=" . "$inserted_id");  //added by shariat
            } else {
                $data = array(
                    'report' => $report,
                    'date' => $date,
                    'sample_coll_date' => $sample_coll_date
                );
                $this->lab_model->updateLab($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
				redirect("lab/invoice?id=" . "$id");  //added by shariat
            }
        }
    }

    function editLab() {
        if ($this->ion_auth->in_group(array('admin', 'Doctor', 'Laboratorist', 'Nurse', 'Patient'))) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $data['categories'] = $this->lab_model->getLabCategory();
            $data['patients'] = $this->patient_model->getPatient();
            $data['doctors'] = $this->doctor_model->getDoctor();
            $id = $this->input->get('id');
            $data['lab'] = $this->lab_model->getLabById($id);
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_lab_view', $data);
            $this->load->view('home/footer'); // just the footer file
        }
    }

    function delete() {
        if ($this->ion_auth->in_group(array('admin'))) {
            $id = $this->input->get('id');
            $this->lab_model->deleteLab($id);
            $this->session->set_flashdata('feedback', lang('report').' of ID '. $id. ' '.lang('deleted')); //changed by Shariat
            redirect('lab/lab1'); //changed by Shariat
        } else {
            redirect('home/permission');
        }
    }

    public function template() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['settings'] = $this->settings_model->getSettings();
        $data['templates'] = $this->lab_model->getTemplate();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('template', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addTemplateView() {
        $data = array();
        $id = $this->input->get('id');
        if (!empty($id)) {
            $data['template'] = $this->lab_model->getTemplateById($id);
        }

        $data['payments_categories'] = $this->finance_model->getPaymentCategoryForLab(); //added by shariat
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_template', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getTemplateByIdByJason() {
        $id = $this->input->get('id');
        $data['template'] = $this->lab_model->getTemplateById($id);
        echo json_encode($data);
    }

    public function addTemplate() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $template = $this->input->post('template');
        $user = $this->ion_auth->get_user_id();


        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('template', 'Template', 'trim|min_length[1]|max_length[10000]|xss_clean');
        $this->form_validation->set_rules('name', 'Name', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            redirect('lab/addTemplate');
        } else {
            $payment_category=$this->finance_model->getPaymentCategoryById($name);
            $payment_category_name=$payment_category->category.', '.$this->finance_model->getPaymentServiceCategoryById($payment_category->service_category)->category;

            $data = array();
            if (empty($id)) {
                $data = array(
                    'name' => $payment_category_name,
                    'template' => $template,
                    'user' => $user,
                    'x' => $name,
                );
                $this->lab_model->insertTemplate($data);
                $inserted_id = $this->db->insert_id();
                $this->session->set_flashdata('feedback', lang('added'));
                redirect("lab/template");
            } else {
                $data = array(
                    'template' => $template,
                    'user' => $user,
                );
                $this->lab_model->updateTemplate($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
                redirect("lab/template");
            }
        }
    }

    function editTemplate() {
        if ($this->ion_auth->in_group(array('admin', 'Doctor', 'Laboratorist', 'Nurse', 'Patient'))) {
            $data = array();
            $data['settings'] = $this->settings_model->getSettings();
            $id = $this->input->get('id');
            $data['payments_categories'] = $this->finance_model->getPaymentCategoryForLab(); //added by shariat
            $data['template'] = $this->lab_model->getTemplateById($id);
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_template', $data);
            $this->load->view('home/footer'); // just the footer file
        }
    }

    function deleteTemplate() {
        $id = $this->input->get('id');
        $this->lab_model->deleteTemplate($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('lab/template');
    }

    public function labCategory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $data['categories'] = $this->lab_model->getLabCategory();
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_category', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addLabCategoryView() {
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_lab_category');
        $this->load->view('home/footer'); // just the header file
    }

    public function addLabCategory() {
        $id = $this->input->post('id');
        $category = $this->input->post('category');
        $description = $this->input->post('description');
        $reference = $this->input->post('reference_value');


        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
// Validating Category Name Field
        $this->form_validation->set_rules('category', 'Category', 'trim|required|min_length[1]|max_length[100]|xss_clean');
// Validating Description Field
        $this->form_validation->set_rules('description', 'Description', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        // Validating Description Field
        $this->form_validation->set_rules('reference_value', 'Reference Value', 'trim|required|min_length[1]|max_length[1000]|xss_clean');
// Validating Description Field
        $this->form_validation->set_rules('type', 'Type', 'trim|min_length[1]|max_length[100]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (!empty($id)) {
                $this->session->set_flashdata('feedback', lang('vaidation_error'));
                redirect('lab/editLabCategory?id=' . $id);
            } else {
                $data = array();
                $data['setval'] = 'setval';
                $this->load->view('home/dashboard'); // just the header file
                $this->load->view('add_lab_category', $data);
                $this->load->view('home/footer'); // just the header file
            }
        } else {
            $data = array();
            $data = array('category' => $category,
                'description' => $description,
                'reference_value' => $reference,
            );
            if (empty($id)) {
                $this->lab_model->insertLabCategory($data);
                $this->session->set_flashdata('feedback', lang('added'));
            } else {
                $this->lab_model->updateLabCategory($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
            }
            redirect('lab/labCategory');
        }
    }

    function editLabCategory() {
        $data = array();
        $id = $this->input->get('id');
        $data['category'] = $this->lab_model->getLabCategoryById($id);
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_lab_category', $data);
        $this->load->view('home/footer'); // just the footer file
    }

    function deleteLabCategory() {
        $id = $this->input->get('id');
        $this->lab_model->deleteLabCategory($id);
        redirect('lab/labCategory');
    }

    function invoice() {
        $data = array();
        $id = $this->input->get('id');
        $data['lab'] = $this->lab_model->getLabById($id);
        $invoiceId=$data['lab']->invoice;

        if (!file_exists('uploads/barcodes')) {
            mkdir('uploads/barcodes', 0777, true);
        }
		
		//load library
		$this->load->library('zend');
		//load in folder Zend
		$this->zend->load('Zend/Barcode');

        $barcodeOptions = array(
            'text' => $id, 
            'barHeight'=> 15, 
            'factor'=>1.6,
            'drawText' => false,
        );
        $rendererOptions = array();
		//generate barcode
		$imageResource = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();
		imagepng($imageResource, 'uploads/barcodes/'.$id.'.png');
		$data['barcode'] = 'uploads/barcodes/'.$id.'.png';

        $barcodeOptions = array(
            'text' => $invoiceId, 
            'barHeight'=> 15, 
            'factor'=>1.6,
            'drawText' => false,
        );
		//generate barcode
		$imageResource_pat = Zend_Barcode::factory('code128', 'image', $barcodeOptions, $rendererOptions)->draw();
		imagepng($imageResource_pat, 'uploads/barcodes/'.$invoiceId.'.png');
		$data['barcode_invoice'] = 'uploads/barcodes/'.$invoiceId.'.png';


        $data['settings'] = $this->settings_model->getSettings();
      
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('invoice', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    function patientLabHistory() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $patient = $this->input->get('patient');
        if (empty($patient)) {
            $patient = $this->input->post('patient');
        }

        $date_from = strtotime($this->input->post('date_from'));
        $date_to = strtotime($this->input->post('date_to'));
        if (!empty($date_to)) {
            $date_to = $date_to + 86399;
        }

        $data['date_from'] = $date_from;
        $data['date_to'] = $date_to;

        if (!empty($date_from)) {
            $data['labs'] = $this->lab_model->getLabByPatientIdByDate($patient, $date_from, $date_to);
            $data['deposits'] = $this->lab_model->getDepositByPatientIdByDate($patient, $date_from, $date_to);
        } else {
            $data['labs'] = $this->lab_model->getLabByPatientId($patient);
            $data['pharmacy_labs'] = $this->pharmacy_model->getLabByPatientId($patient);
            $data['ot_labs'] = $this->lab_model->getOtLabByPatientId($patient);
            $data['deposits'] = $this->lab_model->getDepositByPatientId($patient);
        }



        $data['patient'] = $this->patient_model->getPatientByid($patient);
        $data['settings'] = $this->settings_model->getSettings();



        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('patient_deposit', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function financialReport() {
        $date_from = strtotime($this->input->post('date_from'));
        $date_to = strtotime($this->input->post('date_to'));
        if (!empty($date_to)) {
            $date_to = $date_to + 86399;
        }
        $data = array();
        $data['lab_categories'] = $this->lab_model->getLabCategory();
        $data['expense_categories'] = $this->lab_model->getExpenseCategory();


// if(empty($date_from)&&empty($date_to)) {
//    $data['labs']=$this->lab_model->get_lab();
//     $data['ot_labs']=$this->lab_model->get_ot_lab();
//     $data['expenses']=$this->lab_model->get_expense();
// }
// else{

        $data['labs'] = $this->lab_model->getLabByDate($date_from, $date_to);
        $data['ot_labs'] = $this->lab_model->getOtLabByDate($date_from, $date_to);
        $data['deposits'] = $this->lab_model->getDepositsByDate($date_from, $date_to);
        $data['expenses'] = $this->lab_model->getExpenseByDate($date_from, $date_to);
// } 
        $data['from'] = $this->input->post('date_from');
        $data['to'] = $this->input->post('date_to');
        $data['settings'] = $this->settings_model->getSettings();
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('financial_report', $data);
        $this->load->view('home/footer'); // just the footer fi
    }

    function getLab() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "invoice",
            "4" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['labs'] = $this->lab_model->getLabBysearch($search, $order, $dir);
            } else {
                $data['labs'] = $this->lab_model->getLabWithoutSearch($order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['labs'] = $this->lab_model->getLabByLimitBySearch($limit, $start, $search, $order, $dir);
            } else {
                $data['labs'] = $this->lab_model->getLabByLimit($limit, $start, $order, $dir);
            }
        }
    

        foreach ($data['labs'] as $lab) {
            $date = date('d-M-Y h:i A', $lab->date);
				$options2 = '<a class="btn btn-xs invoicebutton" title="' . lang('lab') . '" style="color: #fff;" href="lab/invoice?id=' . $lab->id . '"><i class="fa fa-file"></i> ' . lang('') . '</a>';
            if ($this->ion_auth->in_group(array('admin','Laboratorist'))) {
                $options3 = '<a class="btn btn-info btn-xs delete_button" title="' . lang('delete') . '" href="lab/delete?id=' . $lab->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>' . lang('') . '</a>';
            } else {
                $options3 = '';
            }

				$patient_id =$lab->patient;
				$patient_name =ucfirst($lab->patient_name);
				$patient_phone =$lab->patient_phone;
				$category =$lab->category_name;
				$laboratorist= $this->laboratorist_model->getLaboratoristByIonUserId($lab->user)->name; //added by shariat
                $invoiceDetails= $this->finance_model->getPaymentById($lab->invoice); //added by shariat
            
                $info[] = array(
                $lab->id,
                $invoiceDetails->id.', '.date('d-M-Y h:i A', $invoiceDetails->date),
				$patient_name.', '.$patient_id.', '.$patient_phone,                 
                $category,
                $date,
				$laboratorist,
                $options1 . ' ' . $options2 . ' ' . $options3,
            );
        }


        if (!empty($data['labs'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('lab'),
                "recordsFiltered" => $this->db->count_all_results('lab'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }

    function getLabByLaboratorist() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $laboratorist = $this->ion_auth->get_user_id();

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "1" => "invoice",
            "4" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if ($limit == -1) {
            if (!empty($search)) {
                $data['labs'] = $this->lab_model->getLabBysearchByLaboratorist($laboratorist, $search, $order, $dir);
            } else {
                $data['labs'] = $this->lab_model->getLabWithoutSearchByLaboratorist($laboratorist, $order, $dir);
            }
        } else {
            if (!empty($search)) {
                $data['labs'] = $this->lab_model->getLabByLimitBySearchByLaboratorist($laboratorist, $limit, $start, $search, $order, $dir);
            } else {
                $data['labs'] = $this->lab_model->getLabByLimitByLaboratorist($laboratorist, $limit, $start, $order, $dir);
            }
        }
    

        foreach ($data['labs'] as $lab) {
            $date = date('d-M-Y h:i A', $lab->date);	

				$options2 = '<a class="btn btn-xs invoicebutton" title="' . lang('lab') . '" style="color: #fff;" href="lab/invoice?id=' . $lab->id . '"><i class="fa fa-file"></i> ' . lang('') . '</a>';
                //$options3 = '<a class="btn btn-info btn-xs delete_button" title="' . lang('delete') . '" href="lab/delete?id=' . $lab->id . '" onclick="return confirm(\'Are you sure you want to delete this item?\');"><i class="fa fa-trash"></i>' . lang('') . '</a>';
        
				$patient_id =$lab->patient;
				$patient_name =$lab->patient_name;
				$patient_phone =$lab->patient_phone;
				$category =$lab->category_name;
                $invoiceDetails= $this->finance_model->getPaymentById($lab->invoice); //added by shariat
			
            $info[] = array(
                $lab->id,
                $invoiceDetails->id.', '.date('d-M-Y h:i A', $invoiceDetails->date),
				$patient_name.', '.$patient_id,                
				$patient_phone,
                $date,
				$category,
                $options1 . ' ' . $options2 . ' ' . $options3,
                    // $options2 . ' ' . $options3
            );
        }


        if (!empty($data['labs'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('lab'),
                "recordsFiltered" => $this->db->count_all_results('lab'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }
    

    public function myLab() {
        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }

        $data['templates'] = $this->lab_model->getTemplate();
        $data['settings'] = $this->settings_model->getSettings();
        $data['categories'] = $this->lab_model->getLabCategory();
        $data['patients'] = $this->patient_model->getPatient();
        $data['doctors'] = $this->doctor_model->getDoctor();

        $data['settings'] = $this->settings_model->getSettings();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('my_lab', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getLabByDoctor() {
        $requestData = $_REQUEST;
        $start = $requestData['start'];
        $limit = $requestData['length'];
        $search = $this->input->post('search')['value'];
        $doctorIonUser = $this->ion_auth->get_user_id();
        $doctorId=$this->doctor_model->getDoctorByIonUserId($doctorIonUser)->id;

        $order = $this->input->post("order");
        $columns_valid = array(
            "0" => "id",
            "3" => "date",
        );
        $values = $this->settings_model->getColumnOrder($order, $columns_valid);
        $dir = $values[0];
        $order = $values[1];

        if (!empty($search)) {
                $data['labs'] = $this->lab_model->getLabByLimitBySearchByDoctor($doctorId, $limit, $start, $search, $order, $dir);
            } else {
                $data['labs'] = $this->lab_model->getLabByLimitByDoctor($doctorId, $limit, $start, $order, $dir);
        }    

        foreach ($data['labs'] as $lab) {
            $date = date('d-M-Y h:i A', $lab->date);	

				$options2 = '<a class="btn btn-xs invoicebutton" title="' . lang('lab') . '" style="color: #fff;" href="lab/invoice?id=' . $lab->id . '"><i class="fa fa-file"></i> ' . lang('') . '</a>';
         
				$patient_id =$lab->patient;
				$patient_name =ucfirst($lab->patient_name);
				$patient_phone =$lab->patient_phone;
				$category =ucfirst($lab->category);
			
            $info[] = array(
                $lab->id,
				$patient_name.', '.$patient_id.', '.$patient_phone,
                $category,               
                $date,				
                $options1 . ' ' . $options2,
            );
        }


        if (!empty($data['labs'])) {
            $output = array(
                "draw" => intval($requestData['draw']),
                "recordsTotal" => $this->db->count_all_results('lab'),
                "recordsFiltered" => $this->db->count_all_results('lab'),
                "data" => $info
            );
        } else {
            $output = array(
                // "draw" => 1,
                "recordsTotal" => 0,
                "recordsFiltered" => 0,
                "data" => []
            );
        }

        echo json_encode($output);
    }


    public function labByDoctor() {

        if (!$this->ion_auth->logged_in()) {
            redirect('auth/login', 'refresh');
        }
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_by_doctor', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getTemplateByTestIdByJason() {
        $id = $this->input->get('id');
        $data['template'] = $this->lab_model->getTemplateByTestId($id);
        echo json_encode($data);
    }

    public function labFooter() {
        $data['settings'] = $this->settings_model->getSettings();
        $data['labFooters'] = $this->lab_model->getLabFooter();

        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('lab_footer', $data);
        $this->load->view('home/footer'); // just the header file
    }

    public function addLabFooterView() {
        $data = array();
        $id = $this->input->get('id');
        if (!empty($id)) {
            $data['labFooters'] = $this->lab_model->getLabFooterById($id);
        }
        $this->load->view('home/dashboard'); // just the header file
        $this->load->view('add_lab_footer', $data);
        $this->load->view('home/footer'); // just the header file
    }

    function getLabFooterByIdByJason() {
        $id = $this->input->get('id');
        $data['template'] = $this->lab_model->getLabFooterById($id);
        echo json_encode($data);
    }

    public function addLabFooter() {
        $id = $this->input->post('id');
        $name = $this->input->post('name');
        $template = $this->input->post('template');
        $user = $this->ion_auth->get_user_id();

/*         $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('<div class="error">', '</div>');
        $this->form_validation->set_rules('name', 'Lab Footer Name', 'trim|required|min_length[1]|max_length[100]|xss_clean');
        $this->form_validation->set_rules('template', 'Lab Footer', 'trim|min_length[1]|max_length[500]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            redirect('lab/addLabFooter');
        } else { */
            $data = array();
            if (empty($id)) {
                $data = array(
                    'name' => $name,
                    'template' => $template,
                    'user' => $user,
                );
                $this->lab_model->insertLabFooter($data);
                $this->session->set_flashdata('feedback', lang('added'));
                redirect("lab/labFooter");
            } else {
                $data = array(
                    'name' => $name,
                    'template' => $template,
                    'user' => $user,
                );
                $this->lab_model->updateLabFooter($id, $data);
                $this->session->set_flashdata('feedback', lang('updated'));
                redirect("lab/labFooter");
            }
        //}
    }

    function editLabFooter() {
        if ($this->ion_auth->in_group(array('admin', 'Laboratorist',))) {
            $data = array();
            $id = $this->input->get('id');
            $data['settings'] = $this->settings_model->getSettings();
            $data['lab_footer'] = $this->lab_model->getLabFooterById($id);
            $this->load->view('home/dashboard'); // just the header file
            $this->load->view('add_lab_footer', $data);
            $this->load->view('home/footer'); // just the footer file
        }
    }

    function deleteLabFooter() {
        $id = $this->input->get('id');
        $this->lab_model->deleteLabFooter($id);
        $this->session->set_flashdata('feedback', lang('deleted'));
        redirect('lab/labFooter');
    }

}

/* End of file lab.php */
/* Location: ./application/modules/lab/controllers/lab.php */